PROC TABULATE DATA=ghpb20 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ent3 filingsize / PRELOADFMT;
 
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2020';
title3 'All Plans';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ent3=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  

PROC TABULATE DATA=ghpb20 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ent3 filingsize / PRELOADFMT; 
where filingsize='1' and ent3 ne "4";
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2020';
title3 'Plans with 100 or More Participants and Trusts';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ent3=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  

PROC TABULATE DATA=ghpb20 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ent3 filingsize / PRELOADFMT; 
where filingsize='2' and ent3 ne "4";
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2020';
title3 'Plans with 100 or More Participants and No Trusts';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ent3=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  

PROC TABULATE DATA=ghpb20 NOSEPS MISSING;                                                                                                                                                      
CLASS COLLECTIVE_BARGAIN_IND_E INS3 ent3 filingsize / PRELOADFMT; 
where filingsize='3' and ent3 ne "4";
TITLE 'Table A8. Number of Group Health Plans and Total Participants';
title2 'by collective bargaining status, type of insurance, and type of plan, 2020';
title3 'Plans with Fewer Than 100 Participants and Trusts';
KEYWORD ALL / STYLE=[font_size=2 font_weight=bold foreground=black];                                                                                                                                    
KEYLABEL ALL='Total';       
var subtl_act_rtd_sep_CNE / WEIGHT=DUP_WGT; 
VAR dup_wgt;
TABLE (ALL COLLECTIVE_BARGAIN_IND_E='')*(ALL ent3=' '),                                                                                                                                                                   
      (ALL='All Plans' INS3=' ')*                                                                                                                                                                    
      (SUM=' '*DUP_WGT='Number of Plans'*F=COMMA10. SUM=' '*(SUBTL_ACT_RTD_SEP_CNE='Total Participants, End of Year (thousands)'*F=K12f.))                                                                                                                    
      / Box={label='Collective Bargaining Status / Plan Entity'} RTS=20 MISSTEXT='-';                                                                                                                                 
RUN;  
